// ----------------------------------------------------------------------------------
// Microsoft Developer & Platform Evangelism
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
// 
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
// ----------------------------------------------------------------------------------
// The example companies, organizations, products, domain names,
// e-mail addresses, logos, people, places, and events depicted
// herein are fictitious.  No association with any real company,
// organization, product, domain name, email address, logo, person,
// places, or events is intended or should be inferred.
// ----------------------------------------------------------------------------------

namespace SimpleActiveSTS
{
    using System;
    using System.ServiceModel;
    using Microsoft.IdentityModel.Claims;
    using Microsoft.IdentityModel.Configuration;
    using Microsoft.IdentityModel.Protocols.WSTrust;
    using Microsoft.IdentityModel.SecurityTokenService;

    public class WindowsSecurityTokenService : SecurityTokenService
    {
        public WindowsSecurityTokenService(SecurityTokenServiceConfiguration configuration)
            : base(configuration)
        {
        }

        protected override Scope GetScope(IClaimsPrincipal principal, RequestSecurityToken request)
        {
            //// The following line should be uncommented in a production environment
            //// ValidateAppliesTo(request.AppliesTo);

            Scope scope = new Scope(request.AppliesTo.ToString(), SecurityTokenServiceConfiguration.SigningCredentials);

            scope.TokenEncryptionRequired = false;

            return scope;
        }

        protected void ValidateAppliesTo(EndpointAddress appliesTo)
        {
            if (appliesTo == null)
            {
                throw new InvalidRequestException("The appliesTo is null.");
            }

            string addressExpected = "https://yoursolutionName.accesscontrol.int2.windows-int.net/WRAPv0.8";
            if (!appliesTo.Uri.Equals(new Uri(addressExpected)))
            {
                throw new InvalidRequestException(String.Format("The relying party address is not valid. Expected value is {0}, the actual value is {1}.", addressExpected, appliesTo.Uri.AbsoluteUri));
            }
        }

        protected override IClaimsIdentity GetOutputClaimsIdentity(IClaimsPrincipal principal, RequestSecurityToken request, Scope scope)
        {
            IClaimsIdentity callerIdentity = (IClaimsIdentity)principal.Identity;

            IClaimsIdentity outputIdentity = new ClaimsIdentity();

            Claim nameClaim = new Claim(System.IdentityModel.Claims.ClaimTypes.Name, callerIdentity.Name);
            Claim groupClaim = new Claim("http://schemas.xmlsoap.org/claims/Group", "domainadmin");

            outputIdentity.Claims.Add(nameClaim);
            outputIdentity.Claims.Add(groupClaim);

            return outputIdentity;
        }
    }
}